{
	"translatorID": "a823550b-6475-4b20-8539-a3c416906228",
	"label": "Notre Dame Philosophical Reviews",
	"creator": "Emiliano Heyns",
	"target": "^https?://ndpr\\.nd\\.edu/",
	"minVersion": "2.1",
	"maxVersion": "",
	"priority": 100,
	"inRepository": true,
	"translatorType": 4,
	"browserSupport": "gcsibv",
	"lastUpdated": "2016-01-04 21:04:49"
}

// Generated by CoffeeScript 1.10.0

/*
Notre Dame Philosophical Reviews Translator
Copyright (C) 2016 Emiliano Heyns

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
var detectWeb, doWeb, scrape, testCases;

detectWeb = function(doc, url) {
	if (url.indexOf('://ndpr.nd.edu/news') > 0) {
		return 'journalArticle';
	}
	if (url.indexOf('://ndpr.nd.edu/recent-reviews') > 0) {
		return 'multiple';
	}
	if (url.indexOf('://ndpr.nd.edu/search') > 0) {
		return 'multiple';
	}
	return null;
};

scrape = function(doc, url) {
	var author, bibliography, date, index, item, m, reviewedby, reviewer, title;
	item = new Zotero.Item('journalArticle');
	item.publication = 'Notre Dame Philosophical Reviews';
	item.ISSN = '1538-1617';
	item.url = doc.location.href;
	date = doc.getElementsByClassName('pubdate')[0];
	if (date) {
		item.date = date.getAttribute('datetime') || '';
		item.date = item.date.replace(/T.*/, '');
		if (m = item.date.match(/^([0-9]{4})([0-9]{2})([0-9]{2})$/)) {
			item.date = m[1] + "-" + m[2] + "-" + m[3];
		}
	}
	title = doc.getElementsByClassName('entry-title')[0];
	if (title) {
		title = title.textContent;
		item.title = "Review of <i>" + title + "</i>";

		/* shorten to before first colon */
		index = title.indexOf(':');
		if (index >= 0) {
			title = title.substr(0, index);
		}

		/* shorten to after first question mark */
		index = title.indexOf('?');
		if (index >= 0) {
			index++;
			if (index !== title.length) {
				title = title.substr(0, index);
			}
		}
		title = "Review of <i>" + title + "</i>";
		if (title !== item.title) {
			item.shortTitle = title;
		}
	}
	author = doc.getElementsByClassName('author')[0];
	if (author) {
		item.creators.push(Zotero.Utilities.cleanAuthor(author.textContent, 'reviewedAuthor'));
	}
	reviewer = doc.getElementsByClassName('reviewers')[0];
	if (reviewer) {
		reviewedby = doc.getElementsByClassName('reviewed-by')[0];
		if (reviewedby) {
			reviewer.removeChild(reviewedby);
		}
		reviewer = reviewer.textContent.replace(/,.*/, '').trim();
		item.creators.push(Zotero.Utilities.cleanAuthor(reviewer, 'author'));
	}
	bibliography = doc.getElementsByClassName('bibliography')[0];
	if (bibliography) {
		item.notes.push({
			note: "<h1>Bibliography</h1>" + bibliography.innerHTML
		});
	}
	item.attachments.push({
		document: doc,
		title: "NDPR Full Text Snapshot"
	});
	return item.complete();
};

doWeb = function(doc, url) {
	var i, items, j, len, len1, link, ref, ref1;
	if (detectWeb(doc, url) !== 'multiple') {
		return scrape(doc, url);
	}
	items = {};
	ref = doc.querySelectorAll('h1.entry-title a');
	for (i = 0, len = ref.length; i < len; i++) {
		link = ref[i];
		items[link.getAttribute('href')] = link.textContent;
	}
	ref1 = doc.querySelectorAll('div.search-record h3 a');
	for (j = 0, len1 = ref1.length; j < len1; j++) {
		link = ref1[j];
		items[link.getAttribute('href')] = link.textContent.replace(/\/\/.*/, '');
	}
	return Zotero.selectItems(items, function(items) {
		var articles;
		if (!items) {
			return true;
		}
		articles = Object.keys(items);
		ZU.processDocuments(articles, scrape);
	});
};


/** BEGIN TEST CASES **/

var testCases = [
	{
		"type": "web",
		"url": "https://ndpr.nd.edu/news/24395-pleasure-and-the-good-life-concerning-the-nature-varieties-and-plausibility-of-hedonism/",
		"items": [
			{
				"itemType": "journalArticle",
				"title": "Review of <i>Pleasure and the Good Life: Concerning the Nature, Varieties, and Plausibility of Hedonism</i>",
				"creators": [
					{
						"firstName": "Fred",
						"lastName": "Feldman",
						"creatorType": "reviewedAuthor"
					}, {
						"firstName": "Leonard D.",
						"lastName": "Katz",
						"creatorType": "author"
					}
				],
				"date": "2005-03-02",
				"ISSN": "1538-1617",
				"libraryCatalog": "Notre Dame Philosophical Reviews",
				"shortTitle": "Review of <i>Pleasure and the Good Life</i>",
				"url": "https://ndpr.nd.edu/news/24395-pleasure-and-the-good-life-concerning-the-nature-varieties-and-plausibility-of-hedonism/",
				"attachments": [
					{
						"title": "NDPR Full Text Snapshot"
					}
				],
				"tags": [],
				"notes": [
					{
						"note": "<h1>Bibliography</h1><p>Feldman, Fred, <em>Pleasure and the Good Life: Concerning the Nature, Varieties, and Plausibility of Hedonism</em>, Oxford University Press, 2004, 221pp, $35.00 (hbk), ISBN 019926516X.</p>"
					}
				],
				"seeAlso": []
			}
		]
	}, {
		"type": "web",
		"url": "https://ndpr.nd.edu/news/63254-locke-s-touchy-subjects-materialism-and-immortality/",
		"items": [
			{
				"itemType": "journalArticle",
				"title": "Review of <i>Locke's Touchy Subjects: Materialism and Immortality</i>",
				"creators": [
					{
						"firstName": "Nicholas",
						"lastName": "Jolley",
						"creatorType": "reviewedAuthor"
					}, {
						"firstName": "Shelley",
						"lastName": "Weinberg",
						"creatorType": "author"
					}
				],
				"date": "2015-12-17",
				"ISSN": "1538-1617",
				"libraryCatalog": "Notre Dame Philosophical Reviews",
				"shortTitle": "Review of <i>Locke's Touchy Subjects</i>",
				"url": "https://ndpr.nd.edu/news/63254-locke-s-touchy-subjects-materialism-and-immortality/",
				"attachments": [
					{
						"title": "NDPR Full Text Snapshot"
					}
				],
				"tags": [],
				"notes": [
					{
						"note": "<h1>Bibliography</h1><p>Nicholas Jolley, <em>Locke's Touchy Subjects: Materialism and Immortality</em>, Oxford University Press, 2015, 142pp., $50.00 (hbk), ISBN 9780198737094.</p>"
					}
				],
				"seeAlso": []
			}
		]
	}
];


/** END TEST CASES **/
